'use strict';

/* --------------------------------------------------------------
   PayPalLoader.js 2020-06-19
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

(function () {
	if (window.NodeList && !NodeList.prototype.forEach) {
		NodeList.prototype.forEach = Array.prototype.forEach;
	}

	var currentScript = document.currentScript;

	var initDisplayModeECS_ButtonReplace = function initDisplayModeECS_ButtonReplace() {
		var paypalButtonContainer = document.querySelector('#paypal-button-container'),
		    footerTotalRow = document.querySelector('table.order-total tr.footer.total'),
		    newTotalRow = document.createElement('tr'),
		    newTotalRowCell = document.createElement('td');
		newTotalRowCell.colSpan = '2';
		newTotalRowCell.style.width = '100%';
		newTotalRowCell.style.borderTop = 'none';
		newTotalRowCell.appendChild(paypalButtonContainer);
		newTotalRow.appendChild(newTotalRowCell);
		footerTotalRow.parentNode.appendChild(newTotalRow);
		footerTotalRow.querySelectorAll('td').forEach(function (td) {
			td.style.paddingBottom = '15px';
		});
	};

	var initDisplayModeECS = function initDisplayModeECS() {
		if (window.location.search.match(/(\?|&)display_mode=ecs($|&)/)) {
			var checkoutButtons = document.querySelector('div.checkout-buttons');
			if (checkoutButtons) {
				checkoutButtons.style.display = 'none';
			}
			var checkoutSubmitButton = document.querySelector('div.shopping-cart-button a.button-submit');
			if (checkoutSubmitButton === null) {
				checkoutSubmitButton = document.querySelector('tr.checkout-button');
			}
			if (checkoutSubmitButton) {
				checkoutSubmitButton.style.display = 'none';
			}
			var shoppingCartButton = document.querySelector('div.shopping-cart-button');
			if (shoppingCartButton) {
				shoppingCartButton.classList.add('paypal-ecs-mode');
			}
			var ppiContainer = document.querySelector('div.paypalinstallmentcontainer');
			if (ppiContainer) {
				ppiContainer.style.display = 'none';
			}
			initDisplayModeECS_ButtonReplace();
		}
	};

	var initJSSDKPayPalButtonECS = function initJSSDKPayPalButtonECS() {
		var buttonContainer = document.querySelector('#paypal-button-container');
		if (!buttonContainer) {
			return;
		}

		initDisplayModeECS();

		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function createOrder(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function (data) {
					var token = void 0;
					if (data.payment) {
						for (var link in data.payment.links) {
							if (data.payment.links[link].rel === 'approval_url') {
								token = data.payment.links[link].href.match(/EC-\w+/)[0];
							}
						}
					} else {
						//throw new Error(payPalText.paypalUnavailable);
						return false;
					}
					return token;
				});
			},
			onApprove: function onApprove(data, actions) {
				$.ajax({
					url: payPalButtonSettings.authorizedPaymentUrl,
					method: 'post',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
					},
					data: 'paymentID=' + data.paymentID + '&payerID=' + data.payerID
				}).then(function (res) {
					console.debug(res);
					document.location = payPalButtonSettings.checkoutUrl;
				});
			},
			onError: function onError(err) {
				var ppButtonContainer = document.querySelector('#paypal-button-container');
				var ecsIntro = document.querySelector('div.ecs_intro');
				if (ppButtonContainer) {
					var errorMessage = document.querySelector('div.paypal-error');
					if (!errorMessage) {
						errorMessage = document.createElement('div');
						errorMessage.classList.add('paypal-error');
						errorMessage.classList.add('alert');
						errorMessage.classList.add('alert-warning');
						errorMessage.style.textAlign = 'left';
						errorMessage.style.color = '#555';
					}
					errorMessage.innerText = payPalText.paypalUnavailable + ' ';
					var shoppingCartButton = document.querySelector('div.shopping-cart-button');
					if (shoppingCartButton && shoppingCartButton.classList.contains('paypal-ecs-mode')) {
						var linkUrl = window.location.toString().replace('display_mode=ecs', 'display_mode=normal');
						var continueLink = document.createElement('a');
						continueLink.setAttribute('href', linkUrl);
						continueLink.innerText = payPalText.errorContinue;
						errorMessage.append(continueLink);
					}
					ppButtonContainer.parentNode.append(errorMessage);
					ppButtonContainer.style.display = 'none';
				}
				if (ecsIntro) {
					ecsIntro.style.display = 'none';
				}
			}
		}).render('#paypal-button-container');

		document.querySelector('div.ecs_intro').style.display = 'block';

		var observerTarget = document.querySelector('#paypal-button-container');
		var observer = new MutationObserver(function (mutations, observer) {
			mutations.forEach(function (mutation) {
				// console.debug(mutation);
				if (mutation.removedNodes.length > 0) {
					console.info('re-init PayPal buttons');
					initJSSDKPayPalButtonECS();
				}
			});
		});
		observer.observe(observerTarget, { childList: true });
	};

	var initJSSDKPayPalButtonECM = function initJSSDKPayPalButtonECM() {
		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function createOrder(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function (data) {
					var token = void 0;
					for (var link in data.payment.links) {
						if (data.payment.links[link].rel === 'approval_url') {
							token = data.payment.links[link].href.match(/EC-\w+/)[0];
						}
					}
					return token;
				});
			},
			onApprove: function onApprove(data, actions) {
				document.querySelector('#checkout_payment input[name="PayPal2HubPaymentId"]').value = data.paymentID;
				document.querySelector('#checkout_payment input[name="PayPal2HubPayerId"]').value = data.payerID;
				document.querySelector('#checkout_payment').submit();
			}
		}).render('#paypal-button-container');
	};

	var initCheckoutPayment = function initCheckoutPayment() {
		var continueButtonBlock = document.querySelector('#checkout_payment div.continue_button'),
		    continueButton = continueButtonBlock.querySelector('input[type="submit"]'),
		    continueButtonDisplay = continueButton.style.display,
		    paypalButtonContainer = document.createElement('div'),
		    plusContainer = document.querySelector('#gambiohub-ppplus');

		if (plusContainer === null && !payPalButtonSettings.paymentApproved) {
			paypalButtonContainer.id = 'paypal-button-container';
			paypalButtonContainer.style.display = 'none';
			paypalButtonContainer.style.marginTop = '-3px';
			continueButtonBlock.appendChild(paypalButtonContainer);

			initJSSDKPayPalButtonECM();

			var paymentItemClickListener = function paymentItemClickListener() {
				var selected_payment = this.querySelector('input[name="payment"]');
				if (null !== selected_payment) {
					if (selected_payment.value === 'gambio_hub' && selected_payment.dataset.module_code === 'PayPal2Hub') {
						continueButton.style.display = 'none';
						paypalButtonContainer.style.display = 'block';
					} else {
						continueButton.style.display = continueButtonDisplay;
						paypalButtonContainer.style.display = 'none';
					}
				}
			};

			var paymentItems = document.querySelectorAll('#checkout_payment input[name="payment"], #checkout_payment li.list-group-item');
			paymentItems.forEach(function (paymentItem) {
				paymentItem.addEventListener('click', paymentItemClickListener);
			});

			var paymentListEntries = document.querySelectorAll('#checkout_payment li');
			paymentListEntries.forEach(function (paymentOption) {
				if (paymentOption.querySelector('input[name="payment"]:checked') || paymentListEntries.length === 1) {
					paymentOption.dispatchEvent(new Event('click'));
				}
			});
		}
	};

	/****
  ****  Installment Banners
 	 */

	var initInstallmentBanners = function initInstallmentBanners() {
		console.info('Initialising PayPal Installments banners');
		console.info('CartAmount = ' + payPalBannerSettings.cartAmount);
		var banners = document.querySelectorAll('.paypal-installments');
		banners.forEach(function (bannerElement) {
			var position = bannerElement.dataset.ppinstPos;
			console.info('found banner on position ' + position);
			if (payPalBannerSettings.positions && payPalBannerSettings.positions[position]) {
				console.info('settings found for position ' + position);
				console.debug(payPalBannerSettings.positions[position]);
				if (payPalBannerSettings.positions[position].style.layout === 'none') {
					console.info('position disabled');
					return;
				}

				var amount = 0.00;
				if (payPalBannerSettings.cartAmount) {
					amount += payPalBannerSettings.cartAmount;
				}
				var p = document.querySelector('div.current-price-container');
				if (p) {
					amount += 0.01 * parseFloat(p.innerText.replace(/.*?(((\d{1,3}[.,])+)(\d{2})).*/, '$1').replace(/[.,]/g, ''));
				}
				if (amount === 0.00) {
					console.debug('Not showing PayPal Installments banner for amount ' + amount);
				}

				if (bannerElement.classList.contains('paypal-installments-cartbottom')) {
					var observerTarget = document.querySelector('div.shopping-cart-button');
					if (observerTarget) {
						var cartSumElement = document.querySelector('tr.total.sum td:nth-child(2)');
						var amountString = '0';
						if (cartSumElement) {
							amountString = cartSumElement.textContent.trim();
						} else {
							cartSumElement = document.querySelector('tr.footer.total td:nth-child(2)');
							if (cartSumElement) {
								amountString = cartSumElement.textContent.trim().replace(/(\n|\t|\.|\,)/g, '').replace(/.*?([0-9.,]+)\s+EUR.*/, '$1');
							}
						}
						amount = 0.01 * parseInt(amountString.replace(/[^0-9]/g, ''));
						console.info('cart amount ' + amount);

						var observer = new MutationObserver(function (mutations, observer) {
							mutations.forEach(function (mutation) {
								if (mutation.removedNodes.length > 0) {
									console.info('re-init PayPal installments banner');
									initInstallmentBanners();
								}
							});
						});
						observer.observe(observerTarget, { childList: true });
					}
				}

				paypal.Messages({
					amount: amount,
					currency: payPalBannerSettings.currency,
					style: payPalBannerSettings.positions[position].style,
					placement: payPalBannerSettings.positions[position].placement
				}).render(bannerElement).then(function () {
					var legacyInstallmentContainer = document.querySelector('.paypalinstallmentcontainer');
					if (legacyInstallmentContainer) {
						legacyInstallmentContainer.remove();
					}
				});
			}
		});
	};

	var paypalSdkLoaded = function paypalSdkLoaded() {
		console.info('PayPalSDK loaded');
		if (window.location.pathname.match(/shopping_cart.php/)) {
			console.info('Initializing ECS button');
			initJSSDKPayPalButtonECS();
		}
		if (window.location.pathname.match(/checkout_payment.php/)) {
			console.info('Initializing PayPal on payment page');
			initCheckoutPayment();
		}
		initInstallmentBanners();
	};

	var readyCallback = function readyCallback() {
		if (typeof window.paypal === 'undefined') {
			if (!payPalButtonSettings.jssrc) {
				return;
			}

			var jssdk = document.createElement('script');
			jssdk.src = payPalButtonSettings.jssrc ? payPalButtonSettings.jssrc : payPalBannerSettings.jssrc;
			jssdk.onload = paypalSdkLoaded;

			if (currentScript) {
				currentScript.parentNode.insertBefore(jssdk, currentScript);
			} else {
				document.querySelector('script:last-of-type').parentNode.appendChild(jssdk);
			}
		}
	};

	if (document.readyState === 'complete' || document.readyState !== 'loading' && !document.documentElement.doScroll) {
		readyCallback();
	} else {
		document.addEventListener('DOMContentLoaded', readyCallback);
	}
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
